#include "DoubleVBOData.h"

DoubleVBOData::DoubleVBOData(GLuint pProgram, GLsizei sz, GLenum wPrimitive) {
	buffer[0] = new CFeedbackBuffer(pProgram,
			sz, wPrimitive);
	buffer[1] = new CFeedbackBuffer(pProgram,
			sz, wPrimitive);
	current=0;
}

DoubleVBOData::~DoubleVBOData() {
}

void DoubleVBOData::AddGLSLVarying(std::string name) {
	buffer[0]->AddGLSLVarying(name);
	buffer[1]->AddGLSLVarying(name);
}

void DoubleVBOData::Install() {
	buffer[current]->Install();
}

int DoubleVBOData::GetPrimitiveCount(void) const {
	return buffer[current]->GetPrimitiveCount();
}

int DoubleVBOData::GetVertexCount(void) const {
	return buffer[current]->GetVertexCount();
}


void DoubleVBOData::BeginTransformFeedback() {
	buffer[current]->BeginTransformFeedback();
}

void DoubleVBOData::EndTransformFeedback() {
	buffer[current]->EndTransformFeedback();
}

bool DoubleVBOData::Draw(void) {
	return buffer[current]->Draw();
}

void DoubleVBOData::swapBuffers() {
	current=1-current;
}
